/***************************************************************************
 *   Copyright (C) 2007 by Mario Young - www.mayeco.org                    *
 *                                       maye.co@gmail.com                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef NONAME_H
#define NONAME_H

//Qt includes
#include <QHttp>
#include <QXmlStreamReader>

//KDE includes
#include <KUrl>
#include <plasma/applet.h>

//my includes
#include "ui_moodbarConfig.h"
#include "amarok_moodbar.h"


class KDialog;
class KPropertiesDialog;

namespace Plasma
{
    class Svg;
}

class PlasmaMoodBar : public Plasma::Applet
{
    Q_OBJECT
    public:

        PlasmaMoodBar(QObject *parent, const QStringList &args);
        ~PlasmaMoodBar();

        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);
        QSizeF contentSize() const;
        void constraintsUpdated();

    public slots:
        void showConfigurationInterface();

    protected slots:
        void configAccepted();
        
    private:

        KDialog                 *m_dialog;
        HMoodbar                *m_mood;
        int                     m_pixelheight;
        int                     m_pixelwidth;
        QPixmap                 m_pixmap;
        QGraphicsPixmapItem     m_pixmapitem;
        Ui::moodbarConfig       ui;

};

K_EXPORT_PLASMA_APPLET(moodbar, PlasmaMoodBar);

#endif
