/***************************************************************************
 *   Copyright (C) 2007 by Mario Young - www.mayeco.org                    *
 *                                       maye.co@gmail.com                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

//Qt includes
#include <QApplication>
#include <QPainter>
#include <QtCore>
#include <QtGui>
#include <QtNetwork>

//KDE includes
#include <KDebug>
#include <KLocale>
#include <KIconLoader>
#include <KMimeType>
#include <KPropertiesDialog>
#include <KRun>
#include <KSharedConfig>
#include <KUrl>
#include <KDialog>

#include <plasma/svg.h>
#include <plasma/widgets/label.h>
#include <plasma/widgets/icon.h>
#include <plasma/widgets/pushbutton.h>


//my includes
#include "plasmamoodbar.h"
#include "amarok_moodbar.h"

PlasmaMoodBar::PlasmaMoodBar(QObject *parent, const QStringList &args)
    : Plasma::Applet(parent, args),
      m_dialog(0)
{


    setHasConfigurationInterface(true);

    //read a simple config
    KConfigGroup cg = config();
    m_pixelheight = cg.readEntry("height", 100);
    m_pixelwidth = cg.readEntry("width", 300);

    //create the first step
    m_mood = new HMoodbar();

    //send a valid file here
    #error Please set a valid .mood file and remove this line, sorry!
    m_mood->readFile( QString ( "/path/to/valid/file.mood" ) );

    //save the moodbar pixmap in m_pixmap draw the 
    m_pixmap = m_mood->draw ( m_pixelwidth, m_pixelheight );

}

PlasmaMoodBar::~PlasmaMoodBar()
{

    //write the config
    KConfigGroup cg = config();
    cg.writeEntry( "width", m_pixelwidth );
    cg.writeEntry( "height", m_pixelheight );

}

QSizeF PlasmaMoodBar::contentSize() const
{

    return QSizeF(m_pixelwidth, m_pixelheight);

}

void PlasmaMoodBar::showConfigurationInterface()
{
    //show a dialog config
     if (m_dialog == 0) {

        m_dialog = new KDialog;
        m_dialog->setCaption( i18n("Configure PlasmaMoodBar") );

        ui.setupUi(m_dialog->mainWidget());
        m_dialog->setButtons( KDialog::Ok | KDialog::Cancel | KDialog::Apply );

        connect( m_dialog, SIGNAL(applyClicked()), this, SLOT(configAccepted()) );
        connect( m_dialog, SIGNAL(okClicked()), this, SLOT(configAccepted()) );

        ui.spinWidth->setValue( m_pixelwidth );
        ui.spinHeight->setValue( m_pixelheight );

    }

    m_dialog->show();

}

void PlasmaMoodBar::paintInterface(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect &rect)
{

    Q_UNUSED(option)
    Q_UNUSED(rect)

    p->setOpacity(0.7);
    p->drawText(rect, Qt::AlignCenter, QString("Moodbar Applet"));

    //simple we just draw the pixmap
    p->drawPixmap( 0, 0, m_pixmap );


}

void PlasmaMoodBar::configAccepted()
{

    KConfigGroup cg = config();
    cg.writeEntry( "height", m_pixelwidth );
    cg.writeEntry( "height", m_pixelheight );



    QGraphicsItem::update();
    m_pixelheight = ui.spinHeight->value();
    m_pixelwidth = ui.spinWidth->value();
    m_pixmap = m_mood->draw ( m_pixelwidth, m_pixelheight );

    constraintsUpdated();
    
}


void PlasmaMoodBar::constraintsUpdated()
{

    prepareGeometryChange();

}

#include "plasmamoodbar.moc"

